/////////////////////////////////////////////////
// Author: Pierre Gorissen
// File: SCORMFontysAPI.js
// Version: 1.0
// All code in this file is 
// copyright 2004 Fontys Hogescholen
// Re-use allowed for not for profit purposes
// and with this text in place
// Otherwise contact elo-team@fontys.nl
//
/////////////////////////////////////////////////

function showname(){
// Inserts the username into index.htm
// uses GetMyName() to retrieve username from LMS
// 
	MyName = "";
	MyName = GetMyName(); 
	if (myStage.document.all['spanName']) {
		myStage.document.all['spanName'].innerHTML= "Hallo " + MyName + " ";
	}
}

function GetMyName() { 
// Retrieve username from LMS

var UserName = "Onbekend"; 

	UserName = SCOGetValue("cmi.core.student_name"); 
	return UserName;
}


function SCOGetSessionTime() { 
// Retrieve total time from LMS

	if (SCOGetValue("cmi.core.total_time") != "") {
		var SessionTime = SCOGetValue("cmi.core.total_time") + "";
	} else {
		var SessionTime = "00:00:00.00";
	}
	return SessionTime;
}

function SCOMD() { 
// Retrieve MD filename from parameter SCOMD

	var zParam_mdSCO = GetURLParam("SCOMD");
	if (zParam_mdSCO == null) {
		zParam_mdSCO = "Manifest_MD.xml" // should never happen!
	}
	return zParam_mdSCO;
}

function SCOStart() { 
// Retrieve startpage from parameter SCOStart
// then goto that page

	var zParam_urlSCO = GetURLParam("SCOStart");
	if (zParam_urlSCO == null) {
		zParam_urlSCO = myStage.document.location.href; // should never happen!
	}
	GoToPage(zParam_urlSCO);
}


function CheckForResume() { 
// check if we are resuming 
// if this is the case, enable some extra elements on index.htm page

	var URL = SCOGetValue("cmi.core.lesson_location");
	var Resume = "hidden";
	if (URL.length > 0) {
		var Resume = "visible";
	} 
	if (myStage.document.getElementById('ResumeLink')) {
		myStage.document.getElementById('ResumeLink').style.visibility = Resume; 
	}
	if (myStage.document.getElementById('LastSessionTime')) {
		myStage.document.getElementById('LastSessionTime').style.visibility = Resume; 
		myStage.document.getElementById('LastSessionTime').innerHTML = "Tijd gebruikt tot nu toe: " + SCOGetSessionTime()  + ".";
	}
	if (myStage.document.getElementById('Reset1')) {
		myStage.document.getElementById('Reset1').style.visibility = Resume; 
	}
} 


function SetThisPage(URL) { 
// called by each navigable page when displayed  
// URL = this.location.href

	err = SCOSetValue("cmi.core.exit","suspend"); 
	err = SCOSetValue("cmi.core.lesson_location", URL); 
	SCOCommit() ;
	SCOReportSessionTime(); // record used time sofar;

} 

function AllDone() { 
// Not used yet

	if (SCOGetValue("cmi.core.lesson_status") == "incomplete") { 
		err = SCOSetValue("cmi.core.lesson_status", "completed") ;
	} 
	err = SCOCommit();
} 

function GoToPage(URL) { 
// Goto URL 
		myStage.location.href = URL; 
} 



function SCOResume() { 
// Goto Resume URL
 
	if (SCOGetValue("cmi.core.lesson_status") == "incomplete"){ 
		var SuspendLocation = SCOGetValue("cmi.core.lesson_location") 
		if (SuspendLocation.length > 0) { 
			GoToPage(SuspendLocation); 
		} else {
			GoToPage("#"); 
		}
	} 
}

function SCOResetData() { 
// Reset some data
// for demonstration only
 
	err = SCOSetValue("cmi.core.lesson_status", "not attempted"); 
	err = SCOSetValue("cmi.core.lesson_location", "");
	SCOCommit() ;
}


function SCOSaveData() { 
// Called when closing SCO

	err = SCOSetValue("cmi.core.exit","suspend"); 
} 

var xmlDoc; 

function importXML(file) {
// Function used to load MD file 

var xmlDoc; 
var moz = (typeof document.implementation != 'undefined') && (typeof document.implementation.createDocument != 'undefined'); 
var ie = (typeof window.ActiveXObject != 'undefined'); 

	if (moz) { 
		xmlDoc = document.implementation.createDocument("", "", null) 
		xmlDoc.onload = readXML; 
 	} else { 
   		xmlDoc = new ActiveXObject("Microsoft.XMLDOM"); 
   		xmlDoc.async = false; 
   		while(xmlDoc.readyState != 4) {}; 
 	} 

	xmlDoc.load(fullURL(file)); 

	return xmlDoc;
}

function fullURL(file) {
// Concat file name and URL of page

	var URL = myStage.location.href
	var lastslash = URL.lastIndexOf("/");
	if (lastslash > 0) {
		URL = URL.substring(0,lastslash);
	}
	URL = URL + "/" + file; 
	return URL;

}

function printSCOInfo(file) {
// Print information about SCO based on MD file

var xmlDoc;
var outputstring;
var lom, general, lifecycle;
var title, titlestring;
var description, descriptionstring;
var status, statusstring;
var version, versionstring;
var errornr;

try {
	xmlDoc = importXML(file);
	lom = xmlDoc.getElementsByTagName("lom");
	general = lom[0].getElementsByTagName("general");
	lifecycle = lom[0].getElementsByTagName("lifecycle");
} catch(e) {
	errornr = 1;
	// no errorhandling
}
try {
	title = general[0].getElementsByTagName("title");
	titlestring = title[0].getElementsByTagName("langstring");
	titlestring = titlestring[0].firstChild.nodeValue;
} catch(e) {
	errornr += 2;
	titlestring = "Onbekend";
}
try {
	description = general[0].getElementsByTagName("description");
	descriptionstring = description[0].getElementsByTagName("langstring");
	descriptionstring = descriptionstring[0].firstChild.nodeValue;
} catch(e) {
	errornr += 4;
	descriptionstring = "Onbekend";
}
try {
	version = lifecycle[0].getElementsByTagName("version");
	versionstring = version[0].getElementsByTagName("langstring");
	versionstring = versionstring[0].firstChild.nodeValue;
} catch(e) {
	errornr += 8;
	versionstring = "Onbekend";
}
try {
	status = lifecycle[0].getElementsByTagName("status");
	status = status[0].getElementsByTagName("value");
	statusstring = status[0].getElementsByTagName("langstring");
	statusstring = statusstring[0].firstChild.nodeValue;
} catch(e) {
	errornr += 16;
	statusstring = "Onbekend";
}

	outputstring = '<table border="0">'; 
	outputstring +='<tr><th colspan="2">Informatie over deze module</th></tr>';
	outputstring +='<tr><td width="20%">Titel: </td><td>' + titlestring + '</td></tr>';
	outputstring +='<tr><td>Omschrijving: </td><td>' + descriptionstring + '</td></tr>';
	outputstring +='<tr><td>Versie: </td><td>' + versionstring + '</td></tr>';
	outputstring +='<tr><td>Status: </td><td>' + statusstring + '</td></tr>';
	// outputstring +='<tr><td colspan="2">File: ' + fullURL(file) + ' ' + errornr + '</td></tr>';
	outputstring +='</table>';

	if (myStage.document.getElementById('SCOInfo')) {
		myStage.document.getElementById('SCOInfo').innerHTML = outputstring + " ";
	}
	if (myStage.document.getElementById('IndexTitle')) {
		myStage.document.getElementById('IndexTitle').innerHTML = "Welkom bij " + titlestring + " ";
	}

}