// Saved as file "SCORMGenericLogic.js" 
// SCORM 1.2 SCO Logic management script sample 
// Copyright 2001,2002 Click2learn, Inc. 
// concocted by Claude Ostyn 2002-11-09 
// 
// This script implements various aspect of 
// common logic behavior of a SCO. 
// The SCO can be a HTML document or a frameset. 
// 
// Change these preset values to suit your taste and requirements. 
var g_bShowApiErrors = true; 
var g_strAPINotFound = "Management system interface not found."; 
var g_strAPITooDeep = "Cannot find API - too deeply nested."; 
var g_strAPIInitFailed = "Found API but LMSInitialize failed."; 

/////////// API INTERFACE INITIALIZATION AND CATCHER FUNCTIONS //////// 
var g_nFindAPITries = 0; 
var g_objAPI = null; 
var g_bInitDone = false; 
var g_bFinishDone = false; 
var g_bSCOBrowse = false; 
var g_dtmInitialized = new Date(); // will be adjusted after initialize

function AlertUserOfAPIError(strText) { 
	if (g_bShowApiErrors) { 
		alert(strText) 
	} 
} 

function FindAPI(win) { 
	while ((win.API == null) && (win.parent != null) && (win.parent != win)) { 
		g_nFindAPITries ++; 
		if (g_nFindAPITries > 500) { 
			AlertUserOfAPIError(g_strAPITooDeep); 
			return null; 
		} 
		win = win.parent; 
	} 
	return win.API; 
} 

function APIOK() { 
	return ((typeof(g_objAPI)!= "undefined") && (g_objAPI != null)) 
} 

function SCOInitialize() { 

var err = true; 
var state = "ab-initio";

	if (!g_bInitDone) { 
		if ((window.parent) && (window.parent != window)){ 
			g_objAPI = FindAPI(window.parent) 
		} 
		if ((g_objAPI == null) && (window.opener != null)) { 
			g_objAPI = FindAPI(window.opener) 
		} 
		if (!APIOK()) { 
			AlertUserOfAPIError(g_strAPINotFound); 
			err = false 
		} else { 
			err = g_objAPI.LMSInitialize(""); 
			if (err == "true") { 
				g_bSCOBrowse = (g_objAPI.LMSGetValue("cmi.core.lesson_mode") == "browse"); 
				if (!g_bSCOBrowse) { 
					if (g_objAPI.LMSGetValue("cmi.core.lesson_status") == "not attempted") { 
						err = g_objAPI.LMSSetValue("cmi.core.lesson_status","incomplete") ;
					} else {
						state = "resume";
					}
				} 
			} else { 
				AlertUserOfAPIError(g_strAPIInitFailed) 
			} 
		} 
	} 
	if (typeof(SCOInitData) != "undefined") { 
		// The SCOInitData function can be defined in another script of the SCO 
		SCOInitData() 
	} 
	g_dtmInitialized = new Date(); 
	return state;
} 

function SCOFinish() { 
	if ((APIOK()) && (g_bFinishDone == false)) { 
		if (typeof(SCOSaveData) != "undefined"){ 
 			// The SCOSaveData function can be defined in another script of the SCO 
			SCOSaveData();
		} 
		SCOReportSessionTime();
		g_bFinishDone = (g_objAPI.LMSFinish("") == "true"); 
	} 
	return (g_bFinishDone + "" ) // Force type to string 
} 

// Call these catcher functions rather than trying to call the API adapter directly 
function SCOGetValue(nam) {
	return ((APIOK())?g_objAPI.LMSGetValue(nam.toString()):"")
} 
function SCOCommit(parm) {
	return ((APIOK())?g_objAPI.LMSCommit(""):"false")
} 
function SCOGetLastError(parm){
	return ((APIOK())?g_objAPI.LMSGetLastError(""):"-1")
} 
function SCOGetErrorString(n) {
	return ((APIOK())?g_objAPI.LMSGetErrorString(n):"JavaScript")
} 
function SCOGetDiagnostic(p) {
	return ((APIOK())?g_objAPI.LMSGetDiagnostic(p):"JavaScript")
} 


//LMSSetValue is implemented with more complex data 
//management logic below 

// Special logic begins here 
function SCOSetValue(nam,val){ 
var err = ""; 
	if (!APIOK()){ 
		AlertUserOfAPIError("Trying to set value but API not available:\n" + nam + "\n" + val); 
		err = "false" 
	} 
	if (err == ""){ 
		err = g_objAPI.LMSSetValue(nam,val.toString() + ""); 
		if (err != "true") return err 
	} 
	return err 
} 

function MillisecondsToCMIDuration(n) { 
//Convert duration from milliseconds to 0000:00:00.00 format 
	var hms = ""; 
	var dtm = new Date(); 
	dtm.setTime(n); 
	var h = "000" + Math.floor(n / 3600000); 
	var m = "0" + dtm.getMinutes(); 
	var s = "0" + dtm.getSeconds(); 
	var cs = "0" + Math.round(dtm.getMilliseconds() / 10); 
	hms = h.substr(h.length-4)+":"+m.substr(m.length-2)+":"; 
	hms += s.substr(s.length-2)+"."+cs.substr(cs.length-2); return hms 
} 

// SCOReportSessionTime is called automatically by this script, 
// but you may call it at any time also from the SCO 
function SCOReportSessionTime() { 
var dtm = new Date(); 
var n = dtm.getTime() - g_dtmInitialized.getTime(); 
	SCOSetValue("cmi.core.session_time",MillisecondsToCMIDuration(n)) 
}
// Parse any parameters passed on command line

var gaURLParams = new Array();

function URLParams2Array() { 
	var nameVal   = "";                 // Holds array for a single name-value pair. 
	var inString  = unescape(location.search);    // Strips query string from URL. 
	var i = 0; 
	var a = 0;
	var v = "";

	// If URL contains a query string, grabs it. 
	if (inString.charAt(0) == "?") { 
        // Removes "?" character from query string. 
        inString = inString.substring(1, inString.length);
	}
	if (inString.length > 0) { 
   	var aKeypairs = inString.split("&") 
   	// Loops through name-value pairs. 
   	for (i=0;i<aKeypairs.length;i++) { 
		// Splits name-value into array (nameVal[0]=name, nameVal[1]=value). 
			nameVal = aKeypairs[i].split("=");
			v = nameVal[1]
			while (v.indexOf('+') > -1) {
				//Got to do this the hard way because of IE 
				//bug with 'g' in regular expression /+/g 
				v = v.substring(0,v.indexOf('+')) + ' ' + v.substring(v.indexOf('+') + 1);
			}//while
			nameVal[1]= v; 
			// nameVal[1]= unescape(v); 
			nameVal[0] = nameVal[0].toUpperCase();
			gaURLParams[gaURLParams.length] = nameVal;
		}
	} 
} 

URLParams2Array();

function GetURLParam(nam) {
	nam=nam.toUpperCase();
	for (i=0;i<gaURLParams.length;i++){
		if (gaURLParams[i][0]==nam){
			return gaURLParams[i][1]
		}
	}
	return ""
}
  